/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.consul.detector;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.cloud.extend.consul.ConsulProps;
import org.noear.solon.cloud.extend.consul.detector.CpuDetector;
import org.noear.solon.cloud.extend.consul.detector.Detector;
import org.noear.solon.cloud.extend.consul.detector.DiskDetector;
import org.noear.solon.cloud.extend.consul.detector.JvmMemoryDetector;
import org.noear.solon.cloud.extend.consul.detector.MemoryDetector;
import org.noear.solon.cloud.extend.consul.detector.OsDetector;
import org.noear.solon.cloud.extend.consul.detector.QpsDetector;
import org.noear.solon.core.handle.Result;
import org.noear.solon.extend.health.HealthChecker;

public class HealthDetector {
    private static final Detector[] allDetectors = new Detector[]{new CpuDetector(), new JvmMemoryDetector(), new OsDetector(), new QpsDetector(), new MemoryDetector(), new DiskDetector()};
    Set<Detector> detectors = new HashSet<Detector>();
    static HealthDetector detector;

    public void startDetect(SolonApp app) {
        String detectorNamesStr = ConsulProps.instance.getDiscoveryHealthDetector();
        if (Utils.isEmpty((String)detectorNamesStr)) {
            return;
        }
        HashSet<String> detectorNames = new HashSet<String>(Arrays.asList(detectorNamesStr.split(",")));
        for (Detector detector : allDetectors) {
            if (!detectorNames.contains(detector.getName())) continue;
            this.detectors.add(detector);
            if (!(detector instanceof QpsDetector)) continue;
            ((QpsDetector)detector).toDetect(app);
        }
    }

    public Map<String, Object> getInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        for (Detector detector : this.detectors) {
            info.put(detector.getName(), detector.getInfo());
        }
        return info;
    }

    public static void start() {
        if (detector != null) {
            return;
        }
        detector = new HealthDetector();
        detector.startDetect(Solon.global());
        HealthChecker.addIndicator((String)"consul", () -> Result.succeed(detector.getInfo()));
    }
}

