/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.noear.dami.api.Coder;
import org.noear.dami.bus.DamiBus;

public class SenderInvocationHandler
implements InvocationHandler {
    private DamiBus bus;
    private String topicMapping;
    private Coder coder;

    public SenderInvocationHandler(DamiBus bus, String topicMapping, Coder coder) {
        this.bus = bus;
        this.topicMapping = topicMapping;
        this.coder = coder;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String topic = this.topicMapping + "." + method.getName();
        Object content = this.coder.encode(method, args);
        if (method.getReturnType() == Void.class) {
            this.bus.send(topic, content);
            return null;
        }
        return this.bus.requestAndResponse(topic, content);
    }
}

