/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.noear.dami.api.Coder;
import org.noear.dami.api.CoderDefault;
import org.noear.dami.api.DamiApi;
import org.noear.dami.api.MethodTopicListener;
import org.noear.dami.api.SenderInvocationHandler;
import org.noear.dami.bus.DamiBus;

public class DamiApiImpl
implements DamiApi {
    private Map<Method, MethodTopicListener> listenerMap = new HashMap<Method, MethodTopicListener>();
    private Coder coder = new CoderDefault();
    private final DamiBus bus;

    public DamiApiImpl(DamiBus bus) {
        this.bus = bus;
    }

    @Override
    public Coder getCoder() {
        return this.coder;
    }

    @Override
    public void setCoder(Coder coder) {
        if (coder != null) {
            this.coder = coder;
        }
    }

    @Override
    public <T> T createSender(String topicMapping, Class<T> senderClz) {
        return (T)Proxy.newProxyInstance(DamiApi.class.getClassLoader(), new Class[]{senderClz}, (InvocationHandler)new SenderInvocationHandler(this.bus, topicMapping, this.coder));
    }

    @Override
    public synchronized void registerListener(String topicMapping, int index, Object listenerObj) {
        Method[] methods;
        for (Method m1 : methods = listenerObj.getClass().getDeclaredMethods()) {
            MethodTopicListener listener = this.listenerMap.get(m1);
            if (listener == null) {
                listener = new MethodTopicListener(this.bus, listenerObj, m1, this.coder);
                this.listenerMap.put(m1, listener);
            }
            String topic = topicMapping + "." + m1.getName();
            this.bus.listen(topic, index, listener);
        }
    }

    @Override
    public synchronized void unregisterListener(String topicMapping, Object listenerObj) {
        Method[] methods;
        for (Method m1 : methods = listenerObj.getClass().getDeclaredMethods()) {
            MethodTopicListener listener = this.listenerMap.get(m1);
            if (listener == null) continue;
            String topic = topicMapping + "." + m1.getName();
            this.bus.unlisten(topic, listener);
        }
    }
}

