/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;

public class Payload<C, R>
implements Serializable {
    private final String guid;
    private final String topic;
    private final C content;
    private Map<String, Object> attachments;
    protected transient Consumer<R> future;

    public Payload(String topic, C content) {
        this(UUID.randomUUID().toString(), topic, content);
    }

    public Payload(String guid, String topic, C content) {
        this.guid = guid;
        this.topic = topic;
        this.content = content;
    }

    public <T> T getAttachment(String key) {
        if (this.attachments == null) {
            return null;
        }
        return (T)this.attachments.get(key);
    }

    public <T> void setAttachment(String key, T value) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Object>();
        }
        this.attachments.put(key, value);
    }

    public boolean isRequest() {
        return this.future != null;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getTopic() {
        return this.topic;
    }

    public C getContent() {
        return this.content;
    }

    public String toString() {
        return "Payload{guid='" + this.guid + '\'' + ", topic='" + this.topic + '\'' + ", content=" + this.content + ", attachments=" + this.attachments + '}';
    }
}

