/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.noear.dami.bus.DamiBus;
import org.noear.dami.bus.Interceptor;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.TopicListener;
import org.noear.dami.bus.TopicRouter;
import org.noear.dami.bus.TopicRouterImpl;
import org.noear.dami.exception.DamiException;

public final class DamiBusImpl<C, R>
implements DamiBus<C, R> {
    private final TopicRouter<C, R> router = new TopicRouterImpl();
    private long timeout = 3000L;

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void intercept(int index, Interceptor interceptor) {
        this.router.addInterceptor(index, interceptor);
    }

    @Override
    public void send(Payload<C, R> payload) {
        this.router.handle(payload);
    }

    @Override
    public R requestAndResponse(Payload<C, R> payload) {
        CompletableFuture future = new CompletableFuture();
        payload.future = future::complete;
        this.router.handle(payload);
        try {
            return (R)future.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new DamiException(e);
        }
    }

    @Override
    public void requestAndCallback(Payload<C, R> payload, Consumer<R> callback) {
        payload.future = callback;
        this.router.handle(payload);
    }

    @Override
    public void response(Payload<C, R> request, R content) {
        if (!request.isRequest()) {
            throw new DamiException("This payload does not support a response");
        }
        request.future.accept(content);
    }

    @Override
    public void listen(String topic, int index, TopicListener<Payload<C, R>> listener) {
        this.router.add(topic, index, listener);
    }

    @Override
    public void unlisten(String topic, TopicListener<Payload<C, R>> listener) {
        this.router.remove(topic, listener);
    }
}

