/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.noear.dami.api.Coder;
import org.noear.dami.api.CoderDefault;
import org.noear.dami.api.DamiApi;
import org.noear.dami.api.MethodTopicListener;
import org.noear.dami.api.MethodTopicListenerRecord;
import org.noear.dami.api.SenderInvocationHandler;
import org.noear.dami.bus.DamiBus;
import org.noear.dami.exception.DamiException;

public class DamiApiImpl
implements DamiApi {
    private Map<Class<?>, List<MethodTopicListenerRecord>> listenerMap = new HashMap();
    private Coder coder = new CoderDefault();
    private final DamiBus bus;

    public DamiApiImpl(DamiBus bus) {
        this.bus = bus;
    }

    @Override
    public Coder getCoder() {
        return this.coder;
    }

    @Override
    public void setCoder(Coder coder) {
        if (coder != null) {
            this.coder = coder;
        }
    }

    @Override
    public DamiBus getBus() {
        return this.bus;
    }

    @Override
    public <T> T createSender(String topicMapping, Class<T> senderClz) {
        return (T)Proxy.newProxyInstance(DamiApi.class.getClassLoader(), new Class[]{senderClz}, (InvocationHandler)new SenderInvocationHandler(this, senderClz, topicMapping));
    }

    @Override
    public synchronized void registerListener(String topicMapping, int index, Object listenerObj) {
        Class<?> listenerClz = listenerObj.getClass();
        if (this.listenerMap.containsKey(listenerClz)) {
            throw new DamiException("This listener is registered: " + listenerClz.getName());
        }
        ArrayList<MethodTopicListenerRecord> listenerRecords = new ArrayList<MethodTopicListenerRecord>();
        for (Method m1 : this.findMethods(listenerClz)) {
            String topic = this.getMethodTopic(topicMapping, m1.getName());
            MethodTopicListener listener = new MethodTopicListener(this, listenerObj, m1);
            listenerRecords.add(new MethodTopicListenerRecord(topic, listener));
            this.bus.listen(topic, index, listener);
        }
        this.listenerMap.put(listenerClz, listenerRecords);
    }

    @Override
    public synchronized void unregisterListener(String topicMapping, Object listenerObj) {
        List<MethodTopicListenerRecord> tmp = this.listenerMap.remove(listenerObj.getClass());
        if (tmp != null) {
            for (MethodTopicListenerRecord r1 : tmp) {
                this.bus.unlisten(r1.getTopic(), r1.getListener());
            }
        }
    }

    protected Method[] findMethods(Class<?> listenerClz) {
        return listenerClz.getDeclaredMethods();
    }

    protected String getMethodTopic(String topicMapping, String methodName) {
        return topicMapping + "." + methodName;
    }
}

