/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.noear.dami.bus.DamiBus;
import org.noear.dami.bus.Interceptor;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.TopicListener;
import org.noear.dami.bus.TopicRouter;
import org.noear.dami.bus.impl.AcceptorCallback;
import org.noear.dami.bus.impl.AcceptorResponse;
import org.noear.dami.bus.impl.PayloadImpl;
import org.noear.dami.bus.impl.TopicRouterImpl;
import org.noear.dami.exception.DamiException;

public class DamiBusImpl<C, R>
implements DamiBus<C, R> {
    private final TopicRouter<C, R> router = new TopicRouterImpl();
    private long timeout = 3000L;

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void intercept(int index, Interceptor interceptor) {
        this.router.addInterceptor(index, interceptor);
    }

    @Override
    public void send(String topic, C content) {
        this.router.handle(new PayloadImpl(topic, content, null));
    }

    @Override
    public R sendAndResponse(String topic, C content) {
        CompletableFuture future = new CompletableFuture();
        PayloadImpl payload = new PayloadImpl(topic, content, new AcceptorResponse(future));
        this.router.handle(payload);
        try {
            return (R)future.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new DamiException(e);
        }
    }

    @Override
    public void sendAndCallback(String topic, C content, Consumer<R> callback) {
        PayloadImpl<C, R> payload = new PayloadImpl<C, R>(topic, content, new AcceptorCallback<R>(callback));
        this.router.handle(payload);
    }

    @Override
    public void listen(String topic, int index, TopicListener<Payload<C, R>> listener) {
        this.router.add(topic, index, listener);
    }

    @Override
    public void unlisten(String topic, TopicListener<Payload<C, R>> listener) {
        this.router.remove(topic, listener);
    }
}

