/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.dami.api.impl.MethodTopicListener;
import org.noear.dami.bus.Interceptor;
import org.noear.dami.bus.InterceptorChain;
import org.noear.dami.bus.InterceptorEntity;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.TopicListener;
import org.noear.dami.bus.TopicRouter;
import org.noear.dami.bus.impl.TopicListenPipeline;
import org.noear.dami.exception.DamiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TopicRouterImpl<C, R>
implements TopicRouter<C, R>,
Interceptor<C, R> {
    static final Logger log = LoggerFactory.getLogger(TopicRouterImpl.class);
    private final Map<String, TopicListenPipeline<Payload<C, R>>> pipelineMap = new LinkedHashMap<String, TopicListenPipeline<Payload<C, R>>>();
    private final List<InterceptorEntity> interceptors = new ArrayList<InterceptorEntity>();

    public TopicRouterImpl() {
        this.interceptors.add(new InterceptorEntity(Integer.MAX_VALUE, this));
    }

    @Override
    public synchronized void addInterceptor(int index, Interceptor interceptor) {
        this.interceptors.add(new InterceptorEntity(index, interceptor));
        if (this.interceptors.size() > 1) {
            this.interceptors.sort(Comparator.comparing(x -> x.getIndex()));
        }
        if (log.isDebugEnabled()) {
            log.debug("TopicRouter interceptor added: {}", (Object)interceptor.getClass().getName());
        }
    }

    @Override
    public synchronized void add(String topic, int index, TopicListener<Payload<C, R>> listener) {
        this.assertTopic(topic);
        TopicListenPipeline pipeline = this.pipelineMap.computeIfAbsent(topic, t -> new TopicListenPipeline());
        pipeline.add(index, listener);
        if (log.isDebugEnabled()) {
            if (MethodTopicListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("TopicRouter listener added(@{}): {}", (Object)topic, listener);
            } else {
                log.debug("TopicRouter listener added(@{}): {}", (Object)topic, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public synchronized void remove(String topic, TopicListener<Payload<C, R>> listener) {
        this.assertTopic(topic);
        TopicListenPipeline<Payload<C, R>> pipeline = this.pipelineMap.get(topic);
        if (pipeline != null) {
            pipeline.remove(listener);
        }
        if (log.isDebugEnabled()) {
            if (MethodTopicListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("TopicRouter listener removed(@{}): {}", (Object)topic, listener);
            } else {
                log.debug("TopicRouter listener removed(@{}): {}", (Object)topic, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public void handle(Payload<C, R> payload) {
        new InterceptorChain<C, R>(this.interceptors).doIntercept(payload);
    }

    @Override
    public void doIntercept(Payload<C, R> payload, InterceptorChain chain) {
        TopicListenPipeline<Payload<C, R>> pipeline;
        this.assertTopic(payload.getTopic());
        if (log.isTraceEnabled()) {
            log.trace("{}", payload);
        }
        if ((pipeline = this.pipelineMap.get(payload.getTopic())) != null) {
            try {
                pipeline.onEvent(payload);
            }
            catch (InvocationTargetException e) {
                throw new DamiException(e.getTargetException());
            }
            catch (UndeclaredThrowableException e) {
                throw new DamiException(e.getUndeclaredThrowable());
            }
            catch (Throwable e) {
                throw new DamiException(e);
            }
        } else if (log.isWarnEnabled()) {
            log.warn("There's no matching listening on the topic(@{})", (Object)payload.getTopic());
        }
    }

    protected void assertTopic(String topic) {
        if (topic == null || topic.isEmpty()) {
            throw new DamiException("The topic cannot be empty");
        }
    }
}

