/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.dami.bus.Interceptor;
import org.noear.dami.bus.InterceptorChain;
import org.noear.dami.bus.InterceptorEntity;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.TopicRouter;
import org.noear.dami.exception.DamiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class TopicRouterBase<C, R>
implements TopicRouter<C, R>,
Interceptor<C, R> {
    static final Logger baseLog = LoggerFactory.getLogger(TopicRouterBase.class);
    private final List<InterceptorEntity> interceptors = new ArrayList<InterceptorEntity>();

    public TopicRouterBase() {
        this.interceptors.add(new InterceptorEntity(Integer.MAX_VALUE, this));
    }

    @Override
    public synchronized void addInterceptor(int index, Interceptor interceptor) {
        this.interceptors.add(new InterceptorEntity(index, interceptor));
        if (this.interceptors.size() > 1) {
            this.interceptors.sort(Comparator.comparing(x -> x.getIndex()));
        }
        if (baseLog.isDebugEnabled()) {
            baseLog.debug("TopicRouter interceptor added: {}", (Object)interceptor.getClass().getName());
        }
    }

    @Override
    public void handle(Payload<C, R> payload) {
        MDC.put((String)"dami-guid", (String)payload.getGuid());
        new InterceptorChain<C, R>(this.interceptors).doIntercept(payload);
    }

    protected void assertTopic(String topic) {
        if (topic == null || topic.isEmpty()) {
            throw new DamiException("The topic cannot be empty");
        }
    }
}

