/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.api;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.noear.dami.Dami;
import org.noear.dami.api.Coder;
import org.noear.dami.api.CoderDefault;
import org.noear.dami.api.DamiApi;
import org.noear.dami.api.DamiApiConfigurator;
import org.noear.dami.api.impl.MethodTopicListener;
import org.noear.dami.api.impl.MethodTopicListenerRecord;
import org.noear.dami.api.impl.SenderInvocationHandler;
import org.noear.dami.bus.DamiBus;
import org.noear.dami.exception.DamiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamiApiImpl
implements DamiApi,
DamiApiConfigurator {
    static final Logger log = LoggerFactory.getLogger(DamiApiImpl.class);
    private Map<Class<?>, List<MethodTopicListenerRecord>> listenerMap = new HashMap();
    private Coder coder = new CoderDefault();
    private final Supplier<DamiBus> busSupplier;
    private boolean enableDefaultSend;

    public DamiApiImpl() {
        this(() -> Dami.bus());
    }

    public DamiApiImpl(DamiBus bus) {
        this(() -> bus);
    }

    public DamiApiImpl(Supplier<DamiBus> busSupplier) {
        this.busSupplier = busSupplier;
    }

    @Override
    public DamiApiConfigurator enableDefaultSend(boolean enable) {
        this.enableDefaultSend = enable;
        return this;
    }

    @Override
    public DamiApiConfigurator coder(Coder coder) {
        if (coder != null) {
            this.coder = coder;
        }
        return this;
    }

    @Override
    public boolean enableDefaultSend() {
        return this.enableDefaultSend;
    }

    @Override
    public Coder coder() {
        return this.coder;
    }

    @Override
    public DamiBus bus() {
        return this.busSupplier.get();
    }

    @Override
    public <T> T createSender(String topicMapping, Class<T> senderClz) {
        Object tmp = Proxy.newProxyInstance(DamiApi.class.getClassLoader(), new Class[]{senderClz}, (InvocationHandler)new SenderInvocationHandler(this, senderClz, topicMapping));
        if (log.isDebugEnabled()) {
            log.debug("This sender created successfully(@{}.*): {}", (Object)topicMapping, (Object)senderClz.getName());
        }
        return (T)tmp;
    }

    @Override
    public synchronized void registerListener(String topicMapping, int index, Object listenerObj) {
        Class<?> listenerClz = listenerObj.getClass();
        if (this.listenerMap.containsKey(listenerClz)) {
            throw new DamiException("This listener is registered: " + listenerClz.getName());
        }
        ArrayList<MethodTopicListenerRecord> listenerRecords = new ArrayList<MethodTopicListenerRecord>();
        for (Method m1 : this.findMethods(listenerClz)) {
            String topic = this.getMethodTopic(topicMapping, m1.getName());
            MethodTopicListener listener = new MethodTopicListener(this, listenerObj, m1);
            listenerRecords.add(new MethodTopicListenerRecord(topic, listener));
            this.bus().listen(topic, index, listener);
        }
        this.listenerMap.put(listenerClz, listenerRecords);
        if (log.isDebugEnabled()) {
            log.debug("This listener registered successfully(@{}.*): {}", (Object)topicMapping, (Object)listenerObj.getClass().getName());
        }
    }

    @Override
    public synchronized void unregisterListener(String topicMapping, Object listenerObj) {
        List<MethodTopicListenerRecord> tmp = this.listenerMap.remove(listenerObj.getClass());
        if (tmp != null) {
            for (MethodTopicListenerRecord r1 : tmp) {
                this.bus().unlisten(r1.getTopic(), r1.getListener());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("This listener unregistered successfully(@{}.*): {}", (Object)topicMapping, (Object)listenerObj.getClass().getName());
        }
    }

    protected Method[] findMethods(Class<?> listenerClz) {
        return listenerClz.getDeclaredMethods();
    }

    protected String getMethodTopic(String topicMapping, String methodName) {
        return topicMapping + "." + methodName;
    }
}

