/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.noear.dami.DamiBus;
import org.noear.dami.Payload;
import org.noear.dami.TopicListener;
import org.noear.dami.TopicRouter;

public class DamiBusImpl
implements DamiBus {
    private static DamiBus global;
    private TopicRouter router = new TopicRouter();
    private long timeout = 3000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DamiBus global() {
        if (global != null) return global;
        Class<DamiBus> clazz = DamiBus.class;
        synchronized (DamiBus.class) {
            if (global != null) return global;
            global = new DamiBusImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return global;
        }
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void send(String topic, String content) {
        this.router.handle(new Payload(topic, content));
    }

    @Override
    public String requestAndResponse(String topic, String content) {
        Payload payload = new Payload(topic, content);
        payload.future = new CompletableFuture();
        this.router.handle(payload);
        try {
            return payload.future.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void requestAndCallback(String topic, String content, Consumer<String> callback) {
        Payload payload = new Payload(topic, content);
        payload.future = new CompletableFuture();
        payload.future.thenAccept((Consumer)callback);
        this.router.handle(payload);
    }

    @Override
    public void response(Payload request, String content) {
        if (request.future == null) {
            throw new IllegalStateException("This payload does not support a response");
        }
        request.future.complete(content);
    }

    @Override
    public void listen(String topic, TopicListener<Payload> listener) {
        this.router.add(topic, listener);
    }

    @Override
    public void listen(String topic, int index, TopicListener<Payload> listener) {
        this.router.add(topic, index, listener);
    }

    @Override
    public void unlisten(String topic, TopicListener<Payload> listener) {
        this.router.remove(topic, listener);
    }
}

