/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.dami.Payload;
import org.noear.dami.TopicListenPipeline;
import org.noear.dami.TopicListener;

public class TopicRouter {
    private Map<String, TopicListenPipeline<Payload>> pipelineMap = new LinkedHashMap<String, TopicListenPipeline<Payload>>();

    public void add(String topic, TopicListener<Payload> listener) {
        this.add(topic, 0, listener);
    }

    public synchronized void add(String topic, int index, TopicListener<Payload> listener) {
        this.assertTopic(topic);
        TopicListenPipeline<Payload> pipeline = this.pipelineMap.get(topic);
        if (pipeline == null) {
            pipeline = new TopicListenPipeline();
            this.pipelineMap.put(topic, pipeline);
        }
        pipeline.add(index, listener);
    }

    public synchronized void remove(String topic, TopicListener<Payload> listener) {
        this.assertTopic(topic);
        TopicListenPipeline<Payload> pipeline = this.pipelineMap.get(topic);
        if (pipeline != null) {
            pipeline.remove(listener);
        }
    }

    public void handle(Payload payload) {
        this.assertTopic(payload.getTopic());
        TopicListenPipeline<Payload> pipeline = this.pipelineMap.get(payload.getTopic());
        if (pipeline != null) {
            try {
                pipeline.onEvent(payload);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void assertTopic(String topic) {
        if (topic == null || topic.isEmpty()) {
            throw new IllegalArgumentException("The topic cannot be empty");
        }
    }
}

