/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.dami.bus.AssertUtil;
import org.noear.dami.bus.Interceptor;
import org.noear.dami.bus.InterceptorChain;
import org.noear.dami.bus.InterceptorEntity;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.TopicDispatcher;
import org.noear.dami.bus.TopicListenerHolder;
import org.noear.dami.bus.TopicRouter;
import org.noear.dami.exception.DamiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TopicDispatcherDefault<C, R>
implements TopicDispatcher<C, R>,
Interceptor<C, R> {
    static final Logger log = LoggerFactory.getLogger(TopicDispatcherDefault.class);
    private final List<InterceptorEntity> interceptors = new ArrayList<InterceptorEntity>();

    public TopicDispatcherDefault() {
        this.interceptors.add(new InterceptorEntity(Integer.MAX_VALUE, this));
    }

    @Override
    public synchronized void addInterceptor(int index, Interceptor interceptor) {
        this.interceptors.add(new InterceptorEntity(index, interceptor));
        if (this.interceptors.size() > 1) {
            this.interceptors.sort(Comparator.comparing(x -> x.getIndex()));
        }
        if (log.isDebugEnabled()) {
            log.debug("TopicDispatcher interceptor added: {}", (Object)interceptor.getClass().getName());
        }
    }

    @Override
    public void doIntercept(Payload<C, R> payload, InterceptorChain<C, R> chain) {
        List<TopicListenerHolder<C, R>> targets;
        if (log.isTraceEnabled()) {
            log.trace("{}", payload);
        }
        if ((targets = chain.getTargets()) != null && targets.size() > 0) {
            try {
                this.doDispatch(payload, chain.getTargets());
                payload.setHandled();
            }
            catch (InvocationTargetException e) {
                throw new DamiException(e.getTargetException());
            }
            catch (UndeclaredThrowableException e) {
                throw new DamiException(e.getUndeclaredThrowable());
            }
            catch (Throwable e) {
                throw new DamiException(e);
            }
        } else if (log.isWarnEnabled()) {
            log.warn("There's no matching listening on the topic(@{})", (Object)payload.getTopic());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Payload<C, R> payload, TopicRouter<C, R> router) {
        AssertUtil.assertTopic(payload.getTopic());
        try {
            MDC.put((String)"dami-plid", (String)payload.getPlid());
            List<TopicListenerHolder<C, R>> targets = router.matching(payload.getTopic());
            new InterceptorChain<C, R>(this.interceptors, targets).doIntercept(payload);
        }
        finally {
            MDC.remove((String)"dami-plid");
        }
    }

    protected void doDispatch(Payload<C, R> payload, List<TopicListenerHolder<C, R>> targets) throws Throwable {
        for (int i = 0; i < targets.size(); ++i) {
            targets.get(i).getListener().onEvent(payload);
        }
    }
}

