/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.noear.dami.api.impl.MethodTopicListener;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.TopicListener;
import org.noear.dami.bus.TopicListenerHolder;
import org.noear.dami.bus.TopicRouter;
import org.noear.dami.bus.impl.Routing;
import org.noear.dami.bus.impl.RoutingFactory;
import org.noear.dami.bus.impl.TopicRouterDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicRouterPatterned<C, R>
implements TopicRouter<C, R> {
    static final Logger log = LoggerFactory.getLogger(TopicRouterDefault.class);
    private final List<Routing<C, R>> routingList = new ArrayList<Routing<C, R>>();
    private final RoutingFactory<C, R> routerFactory;

    public TopicRouterPatterned(RoutingFactory<C, R> routerFactory) {
        this.routerFactory = routerFactory;
    }

    @Override
    public synchronized void add(String topic, int index, TopicListener<Payload<C, R>> listener) {
        this.routingList.add(this.routerFactory.create(topic, index, listener));
        if (log.isDebugEnabled()) {
            if (MethodTopicListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("TopicRouter listener added(@{}): {}", (Object)topic, listener);
            } else {
                log.debug("TopicRouter listener added(@{}): {}", (Object)topic, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public synchronized void remove(String topic, TopicListener<Payload<C, R>> listener) {
        for (int i = 0; i < this.routingList.size(); ++i) {
            Routing<C, R> routing = this.routingList.get(i);
            if (!routing.matches(topic) || routing.getListener() != listener) continue;
            this.routingList.remove(i);
            --i;
        }
        if (log.isDebugEnabled()) {
            if (MethodTopicListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("TopicRouter listener removed(@{}): {}", (Object)topic, listener);
            } else {
                log.debug("TopicRouter listener removed(@{}): {}", (Object)topic, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public void remove(String topic) {
        for (int i = 0; i < this.routingList.size(); ++i) {
            Routing<C, R> routing = this.routingList.get(i);
            if (!routing.matches(topic)) continue;
            this.routingList.remove(i);
            --i;
        }
        if (log.isDebugEnabled()) {
            log.debug("TopicRouter listener removed(@{}): all..", (Object)topic);
        }
    }

    @Override
    public List<TopicListenerHolder<C, R>> matching(String topic) {
        List<TopicListenerHolder<C, R>> routings = this.routingList.stream().filter(r -> r.matches(topic)).sorted(Comparator.comparing(TopicListenerHolder::getIndex)).collect(Collectors.toList());
        return routings;
    }
}

