/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.noear.dami.bus.TopicListener;

public final class TopicListenPipeline<Event>
implements TopicListener<Event> {
    private final List<EH<Event>> list = new ArrayList<EH<Event>>();

    public void add(TopicListener<Event> listener) {
        this.add(0, listener);
    }

    public void add(int index, TopicListener<Event> listener) {
        this.list.add(new EH<Event>(index, listener));
        this.list.sort(Comparator.comparing(EH::getIndex));
    }

    public void remove(TopicListener<Event> listener) {
        this.list.removeIf(e -> e.listener.equals(listener));
    }

    @Override
    public void onEvent(Event event) throws Throwable {
        for (EH<Event> h : this.list) {
            h.listener.onEvent(event);
        }
    }

    private static final class EH<Event> {
        final int index;
        final TopicListener<Event> listener;

        EH(int index, TopicListener<Event> listener) {
            this.index = index;
            this.listener = listener;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

