/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus;

import java.util.LinkedHashMap;
import java.util.Map;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.TopicListenPipeline;
import org.noear.dami.bus.TopicListener;
import org.noear.dami.bus.TopicRouter;

public final class TopicRouterImpl<C, R>
implements TopicRouter<C, R> {
    private final Map<String, TopicListenPipeline<Payload<C, R>>> pipelineMap = new LinkedHashMap<String, TopicListenPipeline<Payload<C, R>>>();

    @Override
    public synchronized void add(String topic, int index, TopicListener<Payload<C, R>> listener) {
        this.assertTopic(topic);
        TopicListenPipeline pipeline = this.pipelineMap.computeIfAbsent(topic, t -> new TopicListenPipeline());
        pipeline.add(index, listener);
    }

    @Override
    public synchronized void remove(String topic, TopicListener<Payload<C, R>> listener) {
        this.assertTopic(topic);
        TopicListenPipeline<Payload<C, R>> pipeline = this.pipelineMap.get(topic);
        if (pipeline != null) {
            pipeline.remove(listener);
        }
    }

    @Override
    public void handle(Payload<C, R> payload) {
        this.assertTopic(payload.getTopic());
        TopicListenPipeline<Payload<C, R>> pipeline = this.pipelineMap.get(payload.getTopic());
        if (pipeline != null) {
            try {
                pipeline.onEvent(payload);
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

