/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.noear.dami.bus.Acceptor;
import org.noear.dami.bus.Payload;
import org.noear.dami.exception.DamiException;

public class PayloadDefault<C, R>
implements Payload<C, R>,
Serializable {
    private final String plid;
    private final String topic;
    private final C content;
    private Map<String, Object> attachments;
    private boolean handled;
    private final transient Acceptor<R> acceptor;

    public PayloadDefault(String plid, String topic, C content, Acceptor<R> acceptor) {
        this.plid = plid;
        this.topic = topic;
        this.content = content;
        this.acceptor = acceptor;
    }

    @Override
    public <T> T getAttachment(String key) {
        if (this.attachments == null) {
            return null;
        }
        return (T)this.attachments.get(key);
    }

    @Override
    public <T> void setAttachment(String key, T value) {
        if (this.attachments == null) {
            this.attachments = new HashMap<String, Object>();
        }
        this.attachments.put(key, value);
    }

    @Override
    public void setHandled() {
        this.handled = true;
    }

    @Override
    public boolean getHandled() {
        return this.handled;
    }

    @Override
    public boolean isRequest() {
        if (this.acceptor != null) {
            return this.acceptor.isSingle();
        }
        return false;
    }

    @Override
    public boolean isSubscribe() {
        if (this.acceptor != null) {
            return !this.acceptor.isSingle();
        }
        return false;
    }

    @Override
    public boolean reply(R content) {
        if (this.acceptor == null) {
            throw new DamiException("This payload does not support a reply");
        }
        if (this.acceptor.isDone()) {
            return false;
        }
        return this.acceptor.accept(content);
    }

    @Override
    public String getPlid() {
        return this.plid;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public C getContent() {
        return this.content;
    }

    public String toString() {
        return "Payload{plid='" + this.plid + '\'' + ", topic='" + this.topic + '\'' + ", content=" + this.content + ", attachments=" + this.attachments + '}';
    }
}

