/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.noear.dami.bus.AssertUtil;
import org.noear.dami.bus.DamiBus;
import org.noear.dami.bus.DamiBusConfigurator;
import org.noear.dami.bus.IdGenerator;
import org.noear.dami.bus.Interceptor;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.PayloadFactory;
import org.noear.dami.bus.TopicDispatcher;
import org.noear.dami.bus.TopicListener;
import org.noear.dami.bus.TopicRouter;
import org.noear.dami.bus.impl.AcceptorRequest;
import org.noear.dami.bus.impl.AcceptorSubscribe;
import org.noear.dami.bus.impl.IdGeneratorDefault;
import org.noear.dami.bus.impl.PayloadDefault;
import org.noear.dami.bus.impl.TopicDispatcherDefault;
import org.noear.dami.bus.impl.TopicRouterDefault;
import org.noear.dami.exception.DamiException;
import org.noear.dami.exception.DamiNoSubscriptionException;

public class DamiBusImpl<C, R>
implements DamiBus<C, R>,
DamiBusConfigurator<C, R> {
    private TopicRouter<C, R> router;
    private TopicDispatcher<C, R> dispatcher;
    private PayloadFactory<C, R> factory;
    private IdGenerator generator;

    public DamiBusImpl(TopicRouter<C, R> router) {
        this.router = router == null ? new TopicRouterDefault() : router;
        this.generator = new IdGeneratorDefault();
        this.factory = PayloadDefault::new;
        this.dispatcher = new TopicDispatcherDefault();
    }

    public DamiBusImpl() {
        this(null);
    }

    @Override
    public DamiBusConfigurator<C, R> topicRouter(TopicRouter<C, R> router) {
        if (router != null) {
            this.router = router;
        }
        return this;
    }

    @Override
    public DamiBusConfigurator<C, R> topicDispatcher(TopicDispatcher<C, R> dispatcher) {
        if (dispatcher != null) {
            this.dispatcher = dispatcher;
        }
        return this;
    }

    @Override
    public DamiBusConfigurator<C, R> payloadFactory(PayloadFactory<C, R> factory) {
        if (factory != null) {
            this.factory = factory;
        }
        return this;
    }

    @Override
    public DamiBusConfigurator<C, R> idGenerator(IdGenerator generator) {
        if (generator != null) {
            this.generator = generator;
        }
        return this;
    }

    @Override
    public void intercept(int index, Interceptor interceptor) {
        this.dispatcher.addInterceptor(index, interceptor);
    }

    @Override
    public boolean send(String topic, C content) {
        AssertUtil.assertTopic(topic);
        Payload<C, R> payload = this.factory.create(this.generator.generate(), topic, content, null);
        this.dispatcher.dispatch(payload, this.router);
        return payload.getHandled();
    }

    @Override
    public R sendAndRequest(String topic, C content, long timeout, Supplier<R> def) {
        AssertUtil.assertTopic(topic);
        CompletableFuture future = new CompletableFuture();
        Payload<C, R> payload = this.factory.create(this.generator.generate(), topic, content, new AcceptorRequest(future));
        this.dispatcher.dispatch(payload, this.router);
        if (payload.getHandled()) {
            try {
                return (R)future.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                throw new DamiException(e);
            }
        }
        if (def == null) {
            throw new DamiNoSubscriptionException("No response subscription");
        }
        return def.get();
    }

    @Override
    public boolean sendAndSubscribe(String topic, C content, Consumer<R> consumer) {
        AssertUtil.assertTopic(topic);
        Payload<C, R> payload = this.factory.create(this.generator.generate(), topic, content, new AcceptorSubscribe<R>(consumer));
        this.dispatcher.dispatch(payload, this.router);
        return payload.getHandled();
    }

    @Override
    public void listen(String topic, int index, TopicListener<Payload<C, R>> listener) {
        this.router.add(topic, index, listener);
    }

    @Override
    public void unlisten(String topic, TopicListener<Payload<C, R>> listener) {
        this.router.remove(topic, listener);
    }

    @Override
    public void unlisten(String topic) {
        this.router.remove(topic);
    }

    @Override
    public TopicRouter<C, R> router() {
        return this.router;
    }
}

