/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus.impl;

import java.util.regex.Pattern;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.TopicListener;
import org.noear.dami.bus.impl.Routing;

public class RoutingPath<C, R>
extends Routing<C, R> {
    private final Pattern pattern;

    public RoutingPath(String expr, int index, TopicListener<Payload<C, R>> listener) {
        super(expr, index, listener);
        if (expr.contains("*")) {
            expr = expr.replace(".", "\\.");
            expr = expr.replace("**", ".[]");
            expr = expr.replace("*", "[^/\\.]*");
            expr = expr.replace(".[]", ".*");
            expr = "^" + expr + "$";
            this.pattern = Pattern.compile(expr);
        } else {
            this.pattern = null;
        }
    }

    @Override
    public boolean matches(String sentTopic) {
        if (super.matches(sentTopic)) {
            return true;
        }
        if (this.pattern != null) {
            return this.pattern.matcher(sentTopic).find();
        }
        return false;
    }
}

