/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.api.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.noear.dami.api.DamiApi;
import org.noear.dami.api.impl.MethodHandlerUtils;
import org.noear.dami.exception.DamiNoSubscriptionException;

public class SenderInvocationHandler
implements InvocationHandler {
    private final DamiApi damiApi;
    private Class<?> interfaceClz;
    private final String topicMapping;

    public SenderInvocationHandler(DamiApi damiApi, Class<?> interfaceClz, String topicMapping) {
        this.damiApi = damiApi;
        this.interfaceClz = interfaceClz;
        this.topicMapping = topicMapping;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            return this.invokeObject(proxy, method, args);
        }
        String topic = this.topicMapping + "." + method.getName();
        Object content = this.damiApi.coder().encode(method, args);
        Object result = null;
        if (method.getReturnType() == Void.TYPE) {
            if (!this.damiApi.bus().send(topic, content) && method.isDefault()) {
                MethodHandlerUtils.invokeDefault(proxy, method, args);
            }
        } else {
            try {
                result = this.damiApi.bus().call(topic, content);
            }
            catch (DamiNoSubscriptionException e) {
                if (method.isDefault()) {
                    result = MethodHandlerUtils.invokeDefault(proxy, method, args);
                }
                throw e;
            }
        }
        return result;
    }

    private Object invokeObject(Object proxy, Method method, Object[] args) throws Throwable {
        String name;
        switch (name = method.getName()) {
            case "toString": {
                return this.interfaceClz.getName() + ".$Proxy{topicMapping='" + this.topicMapping + "'}";
            }
            case "hashCode": {
                return System.identityHashCode(proxy);
            }
            case "equals": {
                return proxy == args[0];
            }
        }
        return method.invoke((Object)this, args);
    }

    public String toString() {
        return "SenderInvocationHandler{interfaceClz=" + this.interfaceClz + ", topicMapping='" + this.topicMapping + '\'' + '}';
    }
}

