/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami.bus;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.noear.dami.bus.Interceptor;
import org.noear.dami.bus.Payload;
import org.noear.dami.bus.TopicListener;
import org.noear.dami.bus.TopicRouter;

public interface DamiBus<C, R> {
    public void intercept(int var1, Interceptor<C, R> var2);

    default public void intercept(Interceptor<C, R> interceptor) {
        this.intercept(0, interceptor);
    }

    public boolean send(String var1, C var2);

    default public R call(String topic, C content) {
        return this.call(topic, content, 3000L);
    }

    default public R call(String topic, C content, long timeout) {
        return this.call(topic, content, timeout, null);
    }

    default public R call(String topic, C content, Supplier<R> fallback) {
        return this.call(topic, content, 3000L, fallback);
    }

    public R call(String var1, C var2, long var3, Supplier<R> var5);

    default public void listen(String topic, TopicListener<Payload<C, R>> listener) {
        this.listen(topic, 0, listener);
    }

    public void listen(String var1, int var2, TopicListener<Payload<C, R>> var3);

    public void unlisten(String var1, TopicListener<Payload<C, R>> var2);

    public void unlisten(String var1);

    public TopicRouter<C, R> router();

    @Deprecated
    default public R sendAndRequest(String topic, C content) {
        return this.sendAndRequest(topic, content, 3000L);
    }

    @Deprecated
    default public R sendAndRequest(String topic, C content, long timeout) {
        return this.sendAndRequest(topic, content, timeout, null);
    }

    @Deprecated
    default public R sendAndRequest(String topic, C content, Supplier<R> fallback) {
        return this.sendAndRequest(topic, content, 3000L, fallback);
    }

    @Deprecated
    default public R sendAndRequest(String topic, C content, long timeout, Supplier<R> fallback) {
        return this.call(topic, content, timeout, fallback);
    }

    @Deprecated
    public boolean sendAndSubscribe(String var1, C var2, Consumer<R> var3);
}

