/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus.route;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.dami2.bus.EventListenPipeline;
import org.noear.dami2.bus.EventListener;
import org.noear.dami2.bus.EventListenerHolder;
import org.noear.dami2.bus.route.EventRouter;
import org.noear.dami2.lpc.impl.ServiceMethodEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRouterDefault
implements EventRouter {
    static final Logger log = LoggerFactory.getLogger(EventRouterDefault.class);
    private final Map<String, EventListenPipeline> pipelineMap = new LinkedHashMap<String, EventListenPipeline>();
    protected final ReentrantLock PIPELINE_MAP_LOCK = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> void add(String topic, int index, EventListener<P> listener) {
        this.PIPELINE_MAP_LOCK.lock();
        try {
            EventListenPipeline pipeline = this.pipelineMap.computeIfAbsent(topic, t -> new EventListenPipeline());
            pipeline.add(index, listener);
        }
        finally {
            this.PIPELINE_MAP_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            if (ServiceMethodEventListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("TopicRouter listener added(@{}): {}", (Object)topic, listener);
            } else {
                log.debug("TopicRouter listener added(@{}): {}", (Object)topic, (Object)listener.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> void remove(String topic, EventListener<P> listener) {
        this.PIPELINE_MAP_LOCK.lock();
        try {
            EventListenPipeline pipeline = this.pipelineMap.get(topic);
            if (pipeline != null) {
                pipeline.remove(listener);
            }
        }
        finally {
            this.PIPELINE_MAP_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            if (ServiceMethodEventListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("TopicRouter listener removed(@{}): {}", (Object)topic, listener);
            } else {
                log.debug("TopicRouter listener removed(@{}): {}", (Object)topic, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public void remove(String topic) {
        this.PIPELINE_MAP_LOCK.lock();
        try {
            this.pipelineMap.remove(topic);
        }
        finally {
            this.PIPELINE_MAP_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("TopicRouter listener removed(@{}): all..", (Object)topic);
        }
    }

    @Override
    public List<EventListenerHolder> matching(String topic) {
        EventListenPipeline pipeline = this.pipelineMap.get(topic);
        if (pipeline == null) {
            return null;
        }
        return pipeline.getList();
    }
}

