/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus.route;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.noear.dami2.bus.EventListener;
import org.noear.dami2.bus.EventListenerHolder;
import org.noear.dami2.bus.route.EventRouter;
import org.noear.dami2.bus.route.EventRouterDefault;
import org.noear.dami2.bus.route.Routing;
import org.noear.dami2.bus.route.RoutingFactory;
import org.noear.dami2.lpc.impl.ServiceMethodEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRouterPatterned
implements EventRouter {
    static final Logger log = LoggerFactory.getLogger(EventRouterDefault.class);
    private final List<Routing> routingList = new ArrayList<Routing>();
    protected final ReentrantLock ROUTING_LIST_LOCK = new ReentrantLock();
    private final RoutingFactory routerFactory;

    public EventRouterPatterned(RoutingFactory routerFactory) {
        this.routerFactory = routerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> void add(String topic, int index, EventListener<P> listener) {
        this.ROUTING_LIST_LOCK.lock();
        try {
            this.routingList.add(this.routerFactory.create(topic, index, listener));
        }
        finally {
            this.ROUTING_LIST_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            if (ServiceMethodEventListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("TopicRouter listener added(@{}): {}", (Object)topic, listener);
            } else {
                log.debug("TopicRouter listener added(@{}): {}", (Object)topic, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public <P> void remove(String topic, EventListener<P> listener) {
        this.ROUTING_LIST_LOCK.lock();
        try {
            this.routingList.removeIf(routing -> routing.matches(topic) && routing.getListener() == listener);
        }
        finally {
            this.ROUTING_LIST_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            if (ServiceMethodEventListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("TopicRouter listener removed(@{}): {}", (Object)topic, listener);
            } else {
                log.debug("TopicRouter listener removed(@{}): {}", (Object)topic, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public void remove(String topic) {
        this.ROUTING_LIST_LOCK.lock();
        try {
            this.routingList.removeIf(routing -> routing.matches(topic));
        }
        finally {
            this.ROUTING_LIST_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("TopicRouter listener removed(@{}): all..", (Object)topic);
        }
    }

    @Override
    public List<EventListenerHolder> matching(String topic) {
        List<EventListenerHolder> routings = this.routingList.stream().filter(r -> r.matches(topic)).sorted(Comparator.comparing(EventListenerHolder::getIndex)).collect(Collectors.toList());
        return routings;
    }
}

