/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus.route;

import java.util.regex.Pattern;
import org.noear.dami2.bus.EventListener;
import org.noear.dami2.bus.route.Routing;

public class RoutingPath<P>
extends Routing<P> {
    private final Pattern pattern;

    public RoutingPath(String expr, int index, EventListener<P> listener) {
        super(expr, index, listener);
        if (expr.contains("*")) {
            expr = expr.replace(".", "\\.");
            expr = expr.replace("**", ".[]");
            expr = expr.replace("*", "[^/\\.]*");
            expr = expr.replace(".[]", ".*");
            expr = "^" + expr + "$";
            this.pattern = Pattern.compile(expr);
        } else {
            this.pattern = null;
        }
    }

    @Override
    public boolean matches(String sentTopic) {
        if (super.matches(sentTopic)) {
            return true;
        }
        if (this.pattern != null) {
            return this.pattern.matcher(sentTopic).find();
        }
        return false;
    }
}

