/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.lpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.noear.dami2.bus.DamiBus;
import org.noear.dami2.exception.DamiException;
import org.noear.dami2.lpc.Coder;
import org.noear.dami2.lpc.CoderDefault;
import org.noear.dami2.lpc.DamiLpc;
import org.noear.dami2.lpc.DamiLpcConfigurator;
import org.noear.dami2.lpc.impl.ConsumerInvocationHandler;
import org.noear.dami2.lpc.impl.ServiceMethodEventListener;
import org.noear.dami2.lpc.impl.TopicListenRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamiLpcImpl
implements DamiLpc,
DamiLpcConfigurator {
    static final Logger log = LoggerFactory.getLogger(DamiLpcImpl.class);
    private Map<Class<?>, List<TopicListenRecord>> serviceMap = new HashMap();
    private ReentrantLock SERVICE_MAP_LOCK = new ReentrantLock();
    private Coder coder = new CoderDefault();
    private final Supplier<DamiBus> busSupplier;

    public DamiLpcImpl(DamiBus bus) {
        this(() -> bus);
    }

    public DamiLpcImpl(Supplier<DamiBus> busSupplier) {
        this.busSupplier = busSupplier;
    }

    @Override
    public DamiLpcConfigurator coder(Coder coder) {
        if (coder != null) {
            this.coder = coder;
        }
        return this;
    }

    @Override
    public Coder coder() {
        return this.coder;
    }

    @Override
    public DamiBus bus() {
        return this.busSupplier.get();
    }

    @Override
    public <T> T createConsumer(String topicMapping, Class<T> consumerApi) {
        Object tmp = Proxy.newProxyInstance(consumerApi.getClassLoader(), new Class[]{consumerApi}, (InvocationHandler)new ConsumerInvocationHandler(this, consumerApi, topicMapping));
        if (log.isDebugEnabled()) {
            log.debug("This consumer created successfully(@{}.*): {}", (Object)topicMapping, (Object)consumerApi.getName());
        }
        return (T)tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerService(String topicMapping, int index, Object serviceObj) {
        Class<?> serviceClz = serviceObj.getClass();
        this.SERVICE_MAP_LOCK.lock();
        try {
            if (this.serviceMap.containsKey(serviceClz)) {
                throw new DamiException("This listener is registered: " + serviceClz.getName());
            }
            ArrayList<TopicListenRecord<ServiceMethodEventListener>> listenerRecords = new ArrayList<TopicListenRecord<ServiceMethodEventListener>>();
            for (Method m1 : this.findMethods(serviceClz)) {
                if (m1.getDeclaringClass() == Object.class) continue;
                String topic = this.getMethodTopic(topicMapping, m1.getName());
                ServiceMethodEventListener listener = new ServiceMethodEventListener(this, serviceObj, m1);
                listenerRecords.add(new TopicListenRecord<ServiceMethodEventListener>(topic, listener));
                this.bus().listen(topic, index, listener);
            }
            this.serviceMap.put(serviceClz, listenerRecords);
        }
        finally {
            this.SERVICE_MAP_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("This service registered successfully(@{}.*): {}", (Object)topicMapping, (Object)serviceObj.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterService(String topicMapping, Object serviceObj) {
        this.SERVICE_MAP_LOCK.lock();
        try {
            List<TopicListenRecord> tmp = this.serviceMap.remove(serviceObj.getClass());
            if (tmp != null) {
                for (TopicListenRecord r1 : tmp) {
                    this.bus().unlisten(r1.getTopic(), r1.getListener());
                }
            }
        }
        finally {
            this.SERVICE_MAP_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("This service unregistered successfully(@{}.*): {}", (Object)topicMapping, (Object)serviceObj.getClass().getName());
        }
    }

    protected Method[] findMethods(Class<?> serviceClz) {
        return serviceClz.getMethods();
    }

    protected String getMethodTopic(String topicMapping, String methodName) {
        return topicMapping + "." + methodName;
    }
}

