/*
 * Copyright 2023～ noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.dami2.bus;

/**
 * 事件监听器持有人（添加序位支持）
 *
 * @author noear
 * @since 1.0
 */
public class EventListenerHolder<P> {
    protected final int index;
    protected final EventListener<P> listener;

    public EventListenerHolder(int index, EventListener<P> listener) {
        this.index = index;
        this.listener = listener;
    }

    /**
     * 获取顺序位
     */
    public int getIndex() {
        return index;
    }

    /**
     * 获取监听器
     */
    public EventListener<P> getListener() {
        return listener;
    }

    @Override
    public String toString() {
        return "TopicListenerHolder{" +
                "index=" + index +
                ", listener=" + listener +
                '}';
    }
}
