/*
 * Copyright 2023～ noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.dami2.bus.intercept;

import org.noear.dami2.bus.Event;

/**
 * 事件拦截器
 *
 * @author noear
 * @since 1.0
 */
public interface EventInterceptor<P> {
    /**
     * 拦截
     *
     * @param event 事件
     * @param chain 拦截链
     */
    void doIntercept(Event<P> event, InterceptorChain<P> chain);
}
