/*
 * Copyright 2023～ noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.dami2.bus.receivable;

import org.noear.dami2.bus.AssertUtil;

import java.io.Serializable;

/**
 * 可接收的荷载
 *
 * @author noear
 * @since 2.0
 */
public class ReceivablePayload<D,Rec> implements Serializable {
    private final D data;
    private final transient Rec sink;

    /**
     * @param data     数据
     * @param sink 接收器
     *
     */
    public ReceivablePayload(D data, Rec sink) {
        AssertUtil.notNull(sink, "The sink can not be null");

        this.data = data;
        this.sink = sink;
    }

    /**
     * 数据
     */
    public D getData() {
        return data;
    }

    /**
     * 接收器
     */
    public Rec getSink() {
        return sink;
    }
}