/*
 * Copyright 2023～ noear.org and authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.noear.dami2.bus.receivable;

import org.noear.dami2.bus.Event;
import org.reactivestreams.Subscriber;

import java.util.Map;

/**
 * 生成流事件处理器
 *
 * @author noear
 * @since 2.0
 */
@FunctionalInterface
public interface StreamEventHandler<D,R> {
    /**
     * 处理流事件（由 onEvent 转发简化）
     *
     * @param event 事件
     * @param att   附件
     * @param data  数据
     * @param sink  接收器（subscriber）
     */
    void onStream(Event<StreamPayload<D, R>> event, Map<String, Object> att, D data, Subscriber<R> sink);

    //（4个参数，是为了与 CallEventHandler （个数上）有错开。便于工具推导）
}