/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.lpc.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.noear.dami2.bus.Result;
import org.noear.dami2.exception.DamiNoListenException;
import org.noear.dami2.lpc.DamiLpc;
import org.noear.dami2.lpc.impl.MethodHandlerUtils;

public class ConsumerInvocationHandler
implements InvocationHandler {
    private final DamiLpc damiApi;
    private Class<?> interfaceClz;
    private final String topicMapping;

    public ConsumerInvocationHandler(DamiLpc damiApi, Class<?> interfaceClz, String topicMapping) {
        this.damiApi = damiApi;
        this.interfaceClz = interfaceClz;
        this.topicMapping = topicMapping;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class)) {
            return this.invokeObject(proxy, method, args);
        }
        String topic = this.topicMapping + "." + method.getName();
        Object data = this.damiApi.coder().encode(method, args);
        Object result = null;
        Result event = this.damiApi.bus().callAsResult(topic, data, null);
        if (method.getReturnType() == Void.TYPE) {
            if (!event.getHandled() && method.isDefault()) {
                MethodHandlerUtils.invokeDefault(proxy, method, args);
            }
        } else if (event.getHandled()) {
            result = ((CompletableFuture)event.getPayload().getSink()).get();
        } else if (method.isDefault()) {
            result = MethodHandlerUtils.invokeDefault(proxy, method, args);
        } else {
            throw new DamiNoListenException("No listen implementation");
        }
        return result;
    }

    private Object invokeObject(Object proxy, Method method, Object[] args) throws Throwable {
        String name;
        switch (name = method.getName()) {
            case "toString": {
                return this.interfaceClz.getName() + ".$Proxy{topicMapping='" + this.topicMapping + "'}";
            }
            case "hashCode": {
                return System.identityHashCode(proxy);
            }
            case "equals": {
                return proxy == args[0];
            }
        }
        return method.invoke((Object)this, args);
    }

    public String toString() {
        return "ConsumerInvocationHandler{interfaceClz=" + this.interfaceClz + ", topicMapping='" + this.topicMapping + '\'' + '}';
    }
}

