/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.dami2.bus.AssertUtil;
import org.noear.dami2.bus.Event;
import org.noear.dami2.bus.EventDispatcher;
import org.noear.dami2.bus.EventListenerHolder;
import org.noear.dami2.bus.intercept.EventInterceptor;
import org.noear.dami2.bus.intercept.InterceptorChain;
import org.noear.dami2.bus.intercept.InterceptorEntity;
import org.noear.dami2.bus.route.EventRouter;
import org.noear.dami2.exception.DamiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcherDefault
implements EventDispatcher,
EventInterceptor {
    static final Logger log = LoggerFactory.getLogger(EventDispatcherDefault.class);
    private final List<InterceptorEntity> interceptors = new ArrayList<InterceptorEntity>();
    private final ReentrantLock INTERCEPTORS_LOCK = new ReentrantLock();

    public EventDispatcherDefault() {
        this.interceptors.add(new InterceptorEntity(Integer.MAX_VALUE, this));
    }

    @Override
    public void addInterceptor(int index, EventInterceptor interceptor) {
        this.INTERCEPTORS_LOCK.lock();
        try {
            this.interceptors.add(new InterceptorEntity(index, interceptor));
            if (this.interceptors.size() > 1) {
                this.interceptors.sort(Comparator.comparing(x -> x.getIndex()));
            }
        }
        finally {
            this.INTERCEPTORS_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("TopicDispatcher interceptor added: {}", (Object)interceptor.getClass().getName());
        }
    }

    public void doIntercept(Event event, InterceptorChain chain) {
        List<EventListenerHolder> targets;
        if (log.isTraceEnabled()) {
            log.trace("{}", (Object)event);
        }
        if ((targets = chain.getTargets()) != null && targets.size() > 0) {
            try {
                this.doDispatch(event, chain.getTargets());
                event.setHandled();
            }
            catch (InvocationTargetException e) {
                throw new DamiException(e.getTargetException());
            }
            catch (UndeclaredThrowableException e) {
                throw new DamiException(e.getUndeclaredThrowable());
            }
            catch (Throwable e) {
                throw new DamiException(e);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("There's no matching listener on the topic(@{})", (Object)event.getTopic());
        }
    }

    @Override
    public void dispatch(Event event, EventRouter router) {
        AssertUtil.assertTopic(event.getTopic());
        List<EventListenerHolder> targets = router.matching(event.getTopic());
        new InterceptorChain(this.interceptors, targets).doIntercept(event);
    }

    protected void doDispatch(Event event, List<EventListenerHolder> targets) throws Throwable {
        for (int i = 0; i < targets.size(); ++i) {
            targets.get(i).getListener().onEvent(event);
        }
    }
}

