/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus.route;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.dami2.bus.EventListenPipeline;
import org.noear.dami2.bus.EventListener;
import org.noear.dami2.bus.EventListenerHolder;
import org.noear.dami2.bus.route.EventRouter;
import org.noear.dami2.lpc.impl.ProviderMethodEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashTopicEventRouter
implements EventRouter {
    static final Logger log = LoggerFactory.getLogger(HashTopicEventRouter.class);
    private final Map<String, EventListenPipeline> pipelineMap = new ConcurrentHashMap<String, EventListenPipeline>();

    @Override
    public <P> void add(String topicExpr, int index, EventListener<P> listener) {
        this.pipelineMap.computeIfAbsent(topicExpr, t -> new EventListenPipeline()).add(index, listener);
        if (log.isDebugEnabled()) {
            if (ProviderMethodEventListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("EventRouter listener added(@{}): {}", (Object)topicExpr, listener);
            } else {
                log.debug("EventRouter listener added(@{}): {}", (Object)topicExpr, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public <P> void remove(String topicExpr, EventListener<P> listener) {
        EventListenPipeline pipeline = this.pipelineMap.get(topicExpr);
        if (pipeline != null) {
            pipeline.remove(listener);
        }
        if (log.isDebugEnabled()) {
            if (ProviderMethodEventListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("EventRouter listener removed(@{}): {}", (Object)topicExpr, listener);
            } else {
                log.debug("EventRouter listener removed(@{}): {}", (Object)topicExpr, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public void remove(String topicExpr) {
        this.pipelineMap.remove(topicExpr);
        if (log.isDebugEnabled()) {
            log.debug("EventRouter listener removed(@{}): all..", (Object)topicExpr);
        }
    }

    @Override
    public List<EventListenerHolder> matching(String topic) {
        EventListenPipeline pipeline = this.pipelineMap.get(topic);
        if (pipeline == null) {
            return Collections.emptyList();
        }
        return pipeline.getList();
    }
}

