/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus.route;

import java.util.regex.Pattern;
import org.noear.dami2.bus.EventListener;
import org.noear.dami2.bus.route.Routing;

public class PathRouting<P>
extends Routing<P> {
    private final Pattern pattern;

    public PathRouting(String expr, int index, EventListener<P> listener) {
        super(expr, index, listener);
        if (expr.indexOf(42) < 0) {
            this.pattern = null;
        } else {
            expr = expr.replace(".", "\\.");
            expr = expr.replace("**", ".[]");
            expr = expr.replace("*", "[^/\\.]*");
            expr = expr.replace(".[]", ".*");
            expr = "^" + expr + "$";
            this.pattern = Pattern.compile(expr);
        }
    }

    public boolean isPatterned() {
        return this.pattern != null;
    }

    @Override
    public boolean matches(String sentTopic) {
        if (super.matches(sentTopic)) {
            return true;
        }
        if (this.pattern != null) {
            return this.pattern.matcher(sentTopic).matches();
        }
        return false;
    }
}

