/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus.route;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.noear.dami2.bus.EventListenPipeline;
import org.noear.dami2.bus.EventListener;
import org.noear.dami2.bus.EventListenerHolder;
import org.noear.dami2.bus.route.EventRouter;
import org.noear.dami2.bus.route.HashTopicEventRouter;
import org.noear.dami2.bus.route.PathRouting;
import org.noear.dami2.bus.route.Routing;
import org.noear.dami2.lpc.impl.ProviderMethodEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTopicEventRouter
implements EventRouter {
    static final Logger log = LoggerFactory.getLogger(HashTopicEventRouter.class);
    private final Map<String, EventListenPipeline> exactMatchMap = new ConcurrentHashMap<String, EventListenPipeline>();
    private final List<Routing> patternRoutes = new CopyOnWriteArrayList<Routing>();

    @Override
    public <P> void add(String topicExpr, int index, EventListener<P> listener) {
        PathRouting<P> routing = new PathRouting<P>(topicExpr, index, listener);
        if (routing.isPatterned()) {
            this.patternRoutes.add(routing);
        } else {
            this.exactMatchMap.computeIfAbsent(topicExpr, k -> new EventListenPipeline()).add(index, listener);
        }
        if (log.isDebugEnabled()) {
            if (ProviderMethodEventListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("EventRouter listener added(@{}): {}", (Object)topicExpr, listener);
            } else {
                log.debug("EventRouter listener added(@{}): {}", (Object)topicExpr, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public <P> void remove(String topicExpr, EventListener<P> listener) {
        EventListenPipeline pipeline = this.exactMatchMap.get(topicExpr);
        if (pipeline != null) {
            pipeline.remove(listener);
        }
        this.patternRoutes.removeIf(routing -> routing.getExpr().equals(topicExpr) && routing.getListener() == listener);
        if (log.isDebugEnabled()) {
            if (ProviderMethodEventListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("EventRouter listener removed(@{}): {}", (Object)topicExpr, listener);
            } else {
                log.debug("EventRouter listener removed(@{}): {}", (Object)topicExpr, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public void remove(String topicExpr) {
        this.exactMatchMap.remove(topicExpr);
        this.patternRoutes.removeIf(routing -> routing.getExpr().equals(topicExpr));
        if (log.isDebugEnabled()) {
            log.debug("EventRouter listener removed(@{}): all..", (Object)topicExpr);
        }
    }

    @Override
    public List<EventListenerHolder> matching(String topic) {
        EventListenPipeline exactMatches;
        ArrayList<EventListenerHolder> result = new ArrayList<EventListenerHolder>();
        if (!this.patternRoutes.isEmpty()) {
            for (Routing routing : this.patternRoutes) {
                if (!routing.matches(topic)) continue;
                result.add(routing);
            }
        }
        if ((exactMatches = this.exactMatchMap.get(topic)) != null) {
            if (result.isEmpty()) {
                return exactMatches.getList();
            }
            result.addAll(exactMatches.getList());
        }
        if (result.size() < 2) {
            return result;
        }
        result.sort(Comparator.comparing(EventListenerHolder::getIndex));
        return result;
    }
}

