/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus.route;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.noear.dami2.bus.EventListener;
import org.noear.dami2.bus.EventListenerHolder;
import org.noear.dami2.bus.route.EventRouter;
import org.noear.dami2.bus.route.HashTopicEventRouter;
import org.noear.dami2.bus.route.TagRouting;
import org.noear.dami2.lpc.impl.ProviderMethodEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagTopicEventRouter
implements EventRouter {
    static final Logger log = LoggerFactory.getLogger(HashTopicEventRouter.class);
    private final Map<String, List<TagRouting>> topicRoutingMap = new ConcurrentHashMap<String, List<TagRouting>>();

    @Override
    public <P> void add(String topicExpr, int index, EventListener<P> listener) {
        TagRouting<P> routing = new TagRouting<P>(topicExpr, index, listener);
        this.topicRoutingMap.computeIfAbsent(routing.getTopic(), k -> new ArrayList()).add(routing);
        if (log.isDebugEnabled()) {
            if (ProviderMethodEventListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("EventRouter listener added(@{}): {}", (Object)topicExpr, listener);
            } else {
                log.debug("EventRouter listener added(@{}): {}", (Object)topicExpr, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public <P> void remove(String topicExpr, EventListener<P> listener) {
        TagRouting.TopicTags topicTags = TagRouting.TopicTags.get(topicExpr);
        List<TagRouting> list = this.topicRoutingMap.get(topicTags.topic);
        if (list != null) {
            list.removeIf(r -> r.getExpr().equals(topicExpr) && r.getListener() == listener);
        }
        if (log.isDebugEnabled()) {
            if (ProviderMethodEventListener.class.isAssignableFrom(listener.getClass())) {
                log.debug("EventRouter listener removed(@{}): {}", (Object)topicExpr, listener);
            } else {
                log.debug("EventRouter listener removed(@{}): {}", (Object)topicExpr, (Object)listener.getClass().getName());
            }
        }
    }

    @Override
    public void remove(String topicExpr) {
        TagRouting.TopicTags topicTags = TagRouting.TopicTags.get(topicExpr);
        List<TagRouting> list = this.topicRoutingMap.get(topicTags.topic);
        list.removeIf(routing -> routing.getExpr().equals(topicExpr));
        if (log.isDebugEnabled()) {
            log.debug("EventRouter listener removed(@{}): all..", (Object)topicExpr);
        }
    }

    @Override
    public List<EventListenerHolder> matching(String topicExpr) {
        TagRouting.TopicTags topicTags = TagRouting.TopicTags.get(topicExpr);
        List<TagRouting> tagRoutes = this.topicRoutingMap.get(topicTags.topic);
        if (tagRoutes == null || tagRoutes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<EventListenerHolder> result = new ArrayList<EventListenerHolder>();
        for (TagRouting routing : tagRoutes) {
            if (!routing.matches(topicTags)) continue;
            result.add(routing);
        }
        if (result.size() < 2) {
            return result;
        }
        result.sort(Comparator.comparing(EventListenerHolder::getIndex));
        return result;
    }
}

