/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus;

import java.util.function.Consumer;
import org.noear.dami2.bus.AssertUtil;
import org.noear.dami2.bus.DamiBus;
import org.noear.dami2.bus.DamiBusConfigurator;
import org.noear.dami2.bus.Event;
import org.noear.dami2.bus.EventDispatcher;
import org.noear.dami2.bus.EventDispatcherDefault;
import org.noear.dami2.bus.EventFactory;
import org.noear.dami2.bus.EventListener;
import org.noear.dami2.bus.Result;
import org.noear.dami2.bus.SimpleEvent;
import org.noear.dami2.bus.intercept.EventInterceptor;
import org.noear.dami2.bus.route.EventRouter;
import org.noear.dami2.bus.route.HashTopicEventRouter;

public class DamiBusImpl
implements DamiBus,
DamiBusConfigurator {
    private EventRouter router;
    private EventDispatcher dispatcher;
    private EventFactory factory;

    public DamiBusImpl(EventRouter router) {
        this.router = router == null ? new HashTopicEventRouter() : router;
        this.factory = SimpleEvent::new;
        this.dispatcher = new EventDispatcherDefault();
    }

    public DamiBusImpl() {
        this(null);
    }

    @Override
    public DamiBusConfigurator eventRouter(EventRouter router) {
        if (router != null) {
            this.router = router;
        }
        return this;
    }

    @Override
    public DamiBusConfigurator eventDispatcher(EventDispatcher dispatcher) {
        if (dispatcher != null) {
            this.dispatcher = dispatcher;
        }
        return this;
    }

    @Override
    public DamiBusConfigurator eventFactory(EventFactory factory) {
        if (factory != null) {
            this.factory = factory;
        }
        return this;
    }

    public void intercept(int index, EventInterceptor interceptor) {
        this.dispatcher.addInterceptor(index, interceptor);
    }

    @Override
    public <P> Result<P> send(String topic, P payload, Consumer<P> fallback) {
        AssertUtil.assertTopic(topic);
        Event<P> event = this.factory.create(topic, payload);
        return this.send(event, fallback);
    }

    @Override
    public <P> Result<P> send(Event<P> event, Consumer<P> fallback) {
        this.dispatcher.dispatch(event, this.router);
        if (!event.getHandled() && fallback != null) {
            fallback.accept(event.getPayload());
        }
        return event;
    }

    @Override
    public <P> void listen(String topic, int index, EventListener<P> listener) {
        this.router.add(topic, index, listener);
    }

    @Override
    public <P> void unlisten(String topic, EventListener<P> listener) {
        this.router.remove(topic, listener);
    }

    @Override
    public void unlisten(String topic) {
        this.router.remove(topic);
    }

    @Override
    public EventRouter router() {
        return this.router;
    }

    @Override
    public DamiBus bus() {
        return this;
    }
}

