/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus.intercept;

import java.util.List;
import org.noear.dami2.bus.Event;
import org.noear.dami2.bus.EventListenerHolder;
import org.noear.dami2.bus.intercept.EventInterceptor;
import org.noear.dami2.bus.intercept.InterceptorEntity;

public class InterceptorChain<P> {
    private final List<InterceptorEntity> interceptors;
    private final List<EventListenerHolder> targets;
    private final EventInterceptor<P> lastHandler;
    private int interceptorIndex = 0;

    public InterceptorChain(List<InterceptorEntity> interceptors, List<EventListenerHolder> targets, EventInterceptor<P> lastHandler) {
        this.interceptors = interceptors;
        this.targets = targets;
        this.lastHandler = lastHandler;
    }

    public List<EventListenerHolder> getTargets() {
        return this.targets;
    }

    public void doIntercept(Event<P> event) {
        if (this.interceptorIndex < this.interceptors.size()) {
            this.interceptors.get(this.interceptorIndex++).doIntercept(event, this);
        } else if (this.lastHandler != null) {
            this.lastHandler.doIntercept(event, this);
        }
    }
}

