/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.bus.receivable;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.noear.dami2.bus.DamiBusExtension;
import org.noear.dami2.bus.Result;
import org.noear.dami2.bus.receivable.CallEventListener;
import org.noear.dami2.bus.receivable.CallPayload;

public interface CallBusExtension
extends DamiBusExtension {
    default public <D, R> CompletableFuture<R> call(String topic, D data) {
        return this.call(topic, data, null);
    }

    default public <D, R> CompletableFuture<R> call(String topic, D data, Consumer<CompletableFuture<R>> fallback) {
        return this.callAsResult(topic, data, fallback).getPayload().getSink();
    }

    default public <D, R> Result<CallPayload<D, R>> callAsResult(String topic, D data) {
        return this.callAsResult(topic, data, null);
    }

    default public <D, R> Result<CallPayload<D, R>> callAsResult(String topic, D data, Consumer<CompletableFuture<R>> fallback) {
        if (fallback == null) {
            return this.bus().send(topic, new CallPayload(data));
        }
        return this.bus().send(topic, new CallPayload(data), r -> fallback.accept((CompletableFuture)r.getSink()));
    }

    default public <D, R> void listen(String topic, CallEventListener<D, R> listener) {
        this.listen(topic, 0, listener);
    }

    default public <D, R> void listen(String topic, int index, CallEventListener<D, R> listener) {
        this.bus().listen(topic, index, listener);
    }
}

