/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.lpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.noear.dami2.bus.DamiBus;
import org.noear.dami2.exception.DamiException;
import org.noear.dami2.lpc.Coder;
import org.noear.dami2.lpc.CoderDefault;
import org.noear.dami2.lpc.DamiLpc;
import org.noear.dami2.lpc.DamiLpcConfigurator;
import org.noear.dami2.lpc.impl.ConsumerInvocationHandler;
import org.noear.dami2.lpc.impl.ProviderMethodEventListener;
import org.noear.dami2.lpc.impl.TopicListenRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DamiLpcImpl
implements DamiLpc,
DamiLpcConfigurator {
    static final Logger log = LoggerFactory.getLogger(DamiLpcImpl.class);
    private Map<Class<?>, List<TopicListenRecord>> providerMap = new HashMap();
    private ReentrantLock PROVIDER_MAP_LOCK = new ReentrantLock();
    private Coder coder = new CoderDefault();
    private final Supplier<DamiBus> busSupplier;

    public DamiLpcImpl(DamiBus bus) {
        this(() -> bus);
    }

    public DamiLpcImpl(Supplier<DamiBus> busSupplier) {
        this.busSupplier = busSupplier;
    }

    @Override
    public DamiLpcConfigurator coder(Coder coder) {
        if (coder != null) {
            this.coder = coder;
        }
        return this;
    }

    @Override
    public Coder coder() {
        return this.coder;
    }

    @Override
    public DamiBus bus() {
        return this.busSupplier.get();
    }

    @Override
    public <T> T createConsumer(String topicMapping, Class<T> consumerApi) {
        Object tmp = Proxy.newProxyInstance(consumerApi.getClassLoader(), new Class[]{consumerApi}, (InvocationHandler)new ConsumerInvocationHandler(this, consumerApi, topicMapping));
        if (log.isDebugEnabled()) {
            log.debug("This consumer created successfully(@{}.*): {}", (Object)topicMapping, (Object)consumerApi.getName());
        }
        return (T)tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProvider(String topicMapping, int index, Object roviderObj) {
        Class<?> roviderClz = roviderObj.getClass();
        this.PROVIDER_MAP_LOCK.lock();
        try {
            if (this.providerMap.containsKey(roviderClz)) {
                throw new DamiException("This listener is registered: " + roviderClz.getName());
            }
            ArrayList<TopicListenRecord<ProviderMethodEventListener>> listenerRecords = new ArrayList<TopicListenRecord<ProviderMethodEventListener>>();
            for (Method m1 : this.findMethods(roviderClz)) {
                if (m1.getDeclaringClass() == Object.class) continue;
                String topic = this.getMethodTopic(topicMapping, m1.getName());
                ProviderMethodEventListener listener = new ProviderMethodEventListener(this, roviderObj, m1);
                listenerRecords.add(new TopicListenRecord<ProviderMethodEventListener>(topic, listener));
                this.bus().listen(topic, index, listener);
            }
            this.providerMap.put(roviderClz, listenerRecords);
        }
        finally {
            this.PROVIDER_MAP_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("This provider registered successfully(@{}.*): {}", (Object)topicMapping, (Object)roviderObj.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProvider(String topicMapping, Object roviderObj) {
        this.PROVIDER_MAP_LOCK.lock();
        try {
            List<TopicListenRecord> tmp = this.providerMap.remove(roviderObj.getClass());
            if (tmp != null) {
                for (TopicListenRecord r1 : tmp) {
                    this.bus().unlisten(r1.getTopic(), r1.getListener());
                }
            }
        }
        finally {
            this.PROVIDER_MAP_LOCK.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("This provider unregistered successfully(@{}.*): {}", (Object)topicMapping, (Object)roviderObj.getClass().getName());
        }
    }

    protected Method[] findMethods(Class<?> roviderClz) {
        return roviderClz.getMethods();
    }

    protected String getMethodTopic(String topicMapping, String methodName) {
        return topicMapping + "." + methodName;
    }
}

