/*
 * Decompiled with CFR 0.152.
 */
package org.noear.dami2.lpc.impl;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class MethodHandlerUtils {
    public static final int JAVA_MAJOR_VERSION;
    private static Method invokeDefaultMethod;

    public static Object invokeDefault(Object proxy, Method method, Object[] args) throws Throwable {
        if (JAVA_MAJOR_VERSION > 15) {
            Method invoke = invokeDefaultMethod;
            return invoke.invoke(null, proxy, method, args);
        }
        Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
        constructor.setAccessible(true);
        Class<?> clazz = method.getDeclaringClass();
        return ((MethodHandles.Lookup)constructor.newInstance(clazz)).in(clazz).unreflectSpecial(method, clazz).bindTo(proxy).invokeWithArguments(args);
    }

    static {
        int majorVersion;
        invokeDefaultMethod = null;
        try {
            String version = System.getProperty("java.specification.version");
            if (version.startsWith("1.")) {
                version = version.substring(2);
            }
            majorVersion = Integer.parseInt(version);
        }
        catch (Throwable ignored) {
            majorVersion = 8;
        }
        JAVA_MAJOR_VERSION = majorVersion;
        if (JAVA_MAJOR_VERSION > 15) {
            Method[] ms;
            for (Method call : ms = InvocationHandler.class.getMethods()) {
                if (!"invokeDefault".equals(call.getName())) continue;
                invokeDefaultMethod = call;
                break;
            }
            if (invokeDefaultMethod == null) {
                throw new UnsupportedOperationException("The current java " + JAVA_MAJOR_VERSION + " is not found: invokeDefault");
            }
        }
    }
}

