/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.health.detector;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.extend.health.detector.AbstractDetector;

public class DiskDetector
extends AbstractDetector {
    private static final Pattern linuxDiskPattern = Pattern.compile("\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+%)\\s+(/.*)", 42);
    private static final Pattern macDiskPattern = Pattern.compile("\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+)\\s+([\\d]+%)\\s+\\d+\\s+\\d+\\s+\\d+%\\s+(/.*)", 42);

    @Override
    public String getName() {
        return "disk";
    }

    @Override
    public Map<String, Object> getInfo() {
        LinkedHashMap<String, Object> details = new LinkedHashMap<String, Object>();
        long totals = 0L;
        long totalUsed = 0L;
        if (osName.indexOf("windows") > -1) {
            for (File file : File.listRoots()) {
                HashMap<String, String> disk = new HashMap<String, String>();
                long total = file.getTotalSpace();
                long free = file.getFreeSpace();
                long used = total - free;
                totals += total;
                totalUsed += used;
                String ratio = (total > 0L ? used * 100L / total : 0L) + "%";
                disk.put("total", DiskDetector.formatByteSize(total));
                disk.put("free", DiskDetector.formatByteSize(free));
                disk.put("used", DiskDetector.formatByteSize(used));
                disk.put("ratio", ratio);
                details.put(file.getPath(), disk);
            }
        } else {
            try {
                String text = this.execute("df", "-m");
                boolean isMac = osName.indexOf("mac os") > -1;
                List<String[]> disks = this.matcher(isMac ? macDiskPattern : linuxDiskPattern, text);
                for (String[] disk : disks) {
                    HashMap<String, String> diskInfo = new HashMap<String, String>();
                    long total = Long.valueOf(disk[1]) * 1024L * 1024L;
                    long used = Long.valueOf(disk[2]) * 1024L * 1024L;
                    long free = Long.valueOf(disk[3]) * 1024L * 1024L;
                    String ratio = disk[4];
                    diskInfo.put("total", DiskDetector.formatByteSize(total));
                    diskInfo.put("free", DiskDetector.formatByteSize(free));
                    diskInfo.put("used", DiskDetector.formatByteSize(used));
                    diskInfo.put("ratio", ratio);
                    details.put(disk[5], diskInfo);
                    totals += total;
                    totalUsed += used;
                }
            }
            catch (Exception ex) {
                EventBus.push((Object)ex);
                details.put("error", "Get Disk Failed:" + ex.getMessage());
            }
        }
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        info.put("total", DiskDetector.formatByteSize(totals));
        info.put("used", DiskDetector.formatByteSize(totalUsed));
        info.put("details", details);
        return info;
    }
}

