/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.health.detector.integration;

import java.util.Arrays;
import java.util.HashSet;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.core.Plugin;
import org.noear.solon.extend.health.HealthChecker;
import org.noear.solon.extend.health.HealthIndicator;
import org.noear.solon.extend.health.detector.CpuDetector;
import org.noear.solon.extend.health.detector.Detector;
import org.noear.solon.extend.health.detector.DiskDetector;
import org.noear.solon.extend.health.detector.JvmMemoryDetector;
import org.noear.solon.extend.health.detector.MemoryDetector;
import org.noear.solon.extend.health.detector.OsDetector;
import org.noear.solon.extend.health.detector.QpsDetector;

public class XPluginImp
implements Plugin {
    private static final Detector[] allDetectors = new Detector[]{new CpuDetector(), new JvmMemoryDetector(), new OsDetector(), new QpsDetector(), new MemoryDetector(), new DiskDetector()};

    public void start(SolonApp app) {
        String detectorNamesStr = Solon.cfg().get("solon.Health.detector");
        if (Utils.isEmpty((String)detectorNamesStr)) {
            return;
        }
        HashSet<String> detectorNames = new HashSet<String>(Arrays.asList(detectorNamesStr.split(",")));
        if (detectorNames.size() == 0) {
            return;
        }
        for (Detector detector : allDetectors) {
            if (!detectorNames.contains("*") && !detectorNames.contains(detector.getName())) continue;
            detector.start();
            HealthChecker.addIndicator((String)detector.getName(), (HealthIndicator)detector);
        }
    }
}

