/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.health.detector.integration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.extend.health.detector.CpuDetector;
import org.noear.solon.extend.health.detector.Detector;
import org.noear.solon.extend.health.detector.DiskDetector;
import org.noear.solon.extend.health.detector.JvmMemoryDetector;
import org.noear.solon.extend.health.detector.MemoryDetector;
import org.noear.solon.extend.health.detector.OsDetector;
import org.noear.solon.extend.health.detector.QpsDetector;

public class MachineDetector
implements Detector {
    private static final Detector[] allDetectors = new Detector[]{new CpuDetector(), new JvmMemoryDetector(), new OsDetector(), new QpsDetector(), new MemoryDetector(), new DiskDetector()};
    private Set<Detector> detectors;

    public void start() {
        if (this.detectors == null) {
            return;
        }
        String detectorNamesStr = Solon.cfg().get("solon.Health.detector");
        HashSet<String> detectorNames = new HashSet<String>(Arrays.asList(detectorNamesStr.split(",")));
        if (detectorNames.size() == 0) {
            return;
        }
        this.detectors = new HashSet<Detector>(detectorNames.size());
        for (Detector detector : allDetectors) {
            if (!detectorNames.contains("*") && !detectorNames.contains(detector.getName())) continue;
            detector.start();
            this.detectors.add(detector);
        }
    }

    @Override
    public String getName() {
        return "machine";
    }

    @Override
    public Map<String, Object> getInfo() {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        for (Detector detector : this.detectors) {
            info.put(detector.getName(), detector.getInfo());
        }
        return info;
    }
}

