/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.health.detector.integration;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.health.HealthChecker;
import org.noear.solon.health.HealthIndicator;
import org.noear.solon.health.detector.Detector;
import org.noear.solon.health.detector.DetectorManager;
import org.noear.solon.health.detector.impl.CpuDetector;
import org.noear.solon.health.detector.impl.DiskDetector;
import org.noear.solon.health.detector.impl.JvmMemoryDetector;
import org.noear.solon.health.detector.impl.MemoryDetector;
import org.noear.solon.health.detector.impl.OsDetector;
import org.noear.solon.health.detector.impl.QpsDetector;

public class XPluginImp
implements Plugin {
    public void start(AopContext context) {
        String detectorNamesStr = Solon.cfg().get("solon.health.detector");
        if (Utils.isEmpty((String)detectorNamesStr)) {
            return;
        }
        HashSet<String> detectorNames = new HashSet<String>(Arrays.asList(detectorNamesStr.split(",")));
        if (detectorNames.size() == 0) {
            return;
        }
        DetectorManager.add(new CpuDetector());
        DetectorManager.add(new JvmMemoryDetector());
        DetectorManager.add(new OsDetector());
        DetectorManager.add(new QpsDetector());
        DetectorManager.add(new MemoryDetector());
        DetectorManager.add(new DiskDetector());
        context.subBeansOfType(Detector.class, detector -> DetectorManager.add(detector));
        context.beanOnloaded(x -> this.onLoaded(detectorNames));
    }

    private void onLoaded(Set<String> detectorNames) {
        for (String name : detectorNames) {
            if ("*".equals(name)) {
                for (Detector detector : DetectorManager.all()) {
                    this.startDo(detector);
                }
                continue;
            }
            Detector detector = DetectorManager.get(name);
            this.startDo(detector);
        }
    }

    private void startDo(Detector detector) {
        if (detector != null) {
            detector.start();
            HealthChecker.addIndicator((String)detector.getName(), (HealthIndicator)detector);
        }
    }
}

