/*
 * Decompiled with CFR 0.152.
 */
package com.drools.solon.config;

import com.drools.solon.KieSchedule;
import com.drools.solon.KieTemplate;
import com.drools.solon.config.DroolsProperties;
import java.util.Objects;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Bean;
import org.noear.solon.annotation.Condition;
import org.noear.solon.annotation.Configuration;
import org.noear.solon.annotation.Inject;

@Configuration
public class DroolsAutoConfiguration {
    @Bean
    @Condition(onMissingBean=KieTemplate.class)
    public KieTemplate kieTemplate(@Inject(value="${spring.drools}") DroolsProperties droolsProperties) {
        String path = droolsProperties.getPath();
        if (Utils.isBlank((String)path)) {
            throw new IllegalArgumentException("Please set base path(spring.drools.path = xxx).");
        }
        KieTemplate kieTemplate = new KieTemplate();
        kieTemplate.setPath(droolsProperties.getPath());
        kieTemplate.setMode(droolsProperties.getMode());
        String autoUpdate = droolsProperties.getAutoUpdate();
        if (Objects.equals("off", autoUpdate)) {
            kieTemplate.setUpdate(999999L);
        } else {
            kieTemplate.setUpdate(droolsProperties.getUpdate());
        }
        kieTemplate.setListener(droolsProperties.getListener());
        kieTemplate.setVerify(droolsProperties.getVerify());
        String charset = droolsProperties.getCharset();
        if (Utils.isNotBlank((String)charset)) {
            kieTemplate.setCharset(charset);
        }
        return kieTemplate;
    }

    @Bean
    @Condition(onMissingBean=KieSchedule.class)
    public KieSchedule kieSchedule(KieTemplate kieTemplate) {
        KieSchedule kieSchedule = new KieSchedule(kieTemplate);
        kieSchedule.execute();
        return kieSchedule;
    }
}

