/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.dubbo;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XProperties;

public class DubboAdapter {
    protected ApplicationConfig application;
    protected Map<String, ReferenceConfig> refMap = new ConcurrentHashMap<String, ReferenceConfig>();
    private static DubboAdapter _global;
    private Thread blockThread = null;

    public static DubboAdapter global() {
        if (_global == null) {
            _global = new DubboAdapter();
        }
        return _global;
    }

    private DubboAdapter() {
        XMap props = null;
        this.application = new ApplicationConfig();
        props = XApp.cfg().getXmap("dubbo.application");
        if (!props.containsKey((Object)"name")) {
            props.put("name", (Object)"dubbo-service-demo");
        }
        XUtil.bindTo((Map)props, (Object)this.application);
        MonitorConfig monitor = new MonitorConfig();
        props = XApp.cfg().getXmap("dubbo.monitor");
        if (props.size() > 0) {
            monitor.setParameters((Map)props);
            this.application.setMonitor(monitor);
        }
        ApplicationModel.getConfigManager().addConfig((AbstractConfig)this.application);
        RegistryConfig registry = new RegistryConfig();
        props = XApp.cfg().getXmap("dubbo.registry");
        if (!props.containsKey((Object)"address")) {
            props.put("address", (Object)"A/N");
        }
        registry.setParameters((Map)props);
        ApplicationModel.getConfigManager().addRegistry(registry);
        ProtocolConfig protocol = new ProtocolConfig();
        props = XApp.cfg().getXmap("dubbo.protocol");
        if (!props.containsKey((Object)"name")) {
            props.put("name", (Object)"dubbo");
        }
        if (!props.containsKey((Object)"port")) {
            props.put("port", (Object)("" + (XApp.global().port() + 20000)));
        }
        protocol.setParameters((Map)props);
        ApplicationModel.getConfigManager().addProtocol(protocol);
        ConsumerConfig consumer = new ConsumerConfig();
        props = XApp.cfg().getXmap("dubbo.consumer");
        if (!props.containsKey((Object)"check")) {
            props.put("check", (Object)"false");
        }
        if (!props.containsKey((Object)"timeout")) {
            props.put("timeout", (Object)"3000");
        }
        consumer.setParameters((Map)props);
        ApplicationModel.getConfigManager().addConsumer(consumer);
    }

    public void startBlock() {
        if (this.blockThread == null) {
            this.blockThread = new Thread(() -> {
                try {
                    System.in.read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.blockThread.start();
        }
    }

    public void stopBlock() {
        if (this.blockThread != null) {
            this.blockThread.stop();
            this.blockThread = null;
        }
    }

    public void regService(ServiceConfig cfg) {
        XProperties prop = XApp.cfg().getProp("dubbo.service." + cfg.getInterface());
        if (prop.size() > 0) {
            XUtil.bindTo((Properties)prop, (Object)cfg);
        }
        cfg.export();
        this.startBlock();
    }

    public <T> T getService(Class<T> clz, Reference ref) {
        String clzKey = null;
        clzKey = ref == null ? clz.getName() : clz.getName() + "_" + ref.version();
        ReferenceConfig cfg = this.refMap.get(clzKey);
        if (cfg == null) {
            cfg = new ReferenceConfig(ref);
            cfg.setInterface(clz);
            XProperties prop = XApp.cfg().getProp("dubbo.reference." + cfg.getInterface());
            if (prop.size() > 0) {
                XUtil.bindTo((Properties)prop, (Object)cfg);
            }
            this.refMap.putIfAbsent(clzKey, cfg);
        }
        return (T)cfg.get();
    }
}

