/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.dubbo;

import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.noear.solon.XApp;
import org.noear.solon.core.Aop;
import org.noear.solon.core.XPlugin;
import org.noear.solon.extend.dubbo.DubboAdapter;
import org.noear.solon.extend.dubbo.EnableDubbo;

public class XPluginImp
implements XPlugin {
    DubboAdapter _server;

    public void start(XApp app) {
        EnableDubbo anno2;
        boolean enableDubbo = true;
        if (app.source() != null && (anno2 = app.source().getAnnotation(EnableDubbo.class)) != null && !anno2.value()) {
            enableDubbo = false;
        }
        this._server = DubboAdapter.global();
        if (enableDubbo) {
            Aop.beanOnloaded(() -> Aop.beanForeach((name, bw) -> {
                if (bw.remoting()) {
                    if (bw.clz().getAnnotation(Service.class) != null) {
                        return;
                    }
                    Class<?>[] ifs = bw.clz().getInterfaces();
                    if (ifs.length == 1) {
                        ServiceConfig cfg = new ServiceConfig();
                        cfg.setInterface(ifs[0]);
                        cfg.setRef(bw.raw());
                        this._server.regService(cfg);
                    }
                }
            }));
            Aop.factory().beanCreatorAdd(Service.class, (clz, bw, anno) -> {
                Class<?>[] ifs = bw.clz().getInterfaces();
                if (ifs.length > 0) {
                    ServiceConfig cfg = new ServiceConfig(anno);
                    if (cfg.getInterface() == null) {
                        cfg.setInterface(ifs[0]);
                    }
                    cfg.setRef(bw.raw());
                    this._server.regService(cfg);
                }
            });
        }
        Aop.factory().beanInjectorAdd(Reference.class, (fwT, anno) -> {
            if (fwT.getType().isInterface()) {
                Object raw = DubboAdapter.global().getService(fwT.getType(), (Reference)anno);
                fwT.setValue(raw);
            }
        });
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stopBlock();
        this._server = null;
    }
}

