/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.extend.dubbo;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.config.AbstractConfig;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ConsumerConfig;
import org.apache.dubbo.config.MonitorConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.config.ServiceConfig;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.Props;

public class DubboAdapter {
    protected ApplicationConfig application;
    protected Map<String, ReferenceConfig> refMap = new ConcurrentHashMap<String, ReferenceConfig>();
    private static DubboAdapter _global;
    private Thread blockThread = null;

    public static DubboAdapter global() {
        if (_global == null) {
            _global = new DubboAdapter();
        }
        return _global;
    }

    private DubboAdapter() {
        NvMap props = null;
        this.application = new ApplicationConfig();
        props = Solon.cfg().getXmap("dubbo.application");
        if (!props.containsKey((Object)"name")) {
            props.put("name", (Object)"dubbo-service-demo");
        }
        Utils.bindTo((Map)props, (Object)this.application);
        MonitorConfig monitor = new MonitorConfig();
        props = Solon.cfg().getXmap("dubbo.monitor");
        if (props.size() > 0) {
            monitor.setParameters((Map)props);
            this.application.setMonitor(monitor);
        }
        ApplicationModel.getConfigManager().addConfig((AbstractConfig)this.application);
        RegistryConfig registry = new RegistryConfig();
        props = Solon.cfg().getXmap("dubbo.registry");
        if (!props.containsKey((Object)"address")) {
            props.put("address", (Object)"A/N");
        }
        registry.setParameters((Map)props);
        ApplicationModel.getConfigManager().addRegistry(registry);
        ProtocolConfig protocol = new ProtocolConfig();
        props = Solon.cfg().getXmap("dubbo.protocol");
        protocol.setParameters((Map)props);
        if (!props.containsKey((Object)"name")) {
            props.put("name", (Object)"dubbo");
            protocol.setName("dubbo");
        }
        if (!props.containsKey((Object)"port")) {
            int port = Solon.cfg().serverPort() + 20000;
            props.put("port", (Object)String.valueOf(port));
            protocol.setPort(Integer.valueOf(port));
        }
        ApplicationModel.getConfigManager().addProtocol(protocol);
        ConsumerConfig consumer = new ConsumerConfig();
        props = Solon.cfg().getXmap("dubbo.consumer");
        if (!props.containsKey((Object)"check")) {
            props.put("check", (Object)"false");
        }
        if (!props.containsKey((Object)"timeout")) {
            props.put("timeout", (Object)"3000");
        }
        consumer.setParameters((Map)props);
        ApplicationModel.getConfigManager().addConsumer(consumer);
    }

    public void startBlock() {
        if (this.blockThread == null) {
            this.blockThread = new Thread(() -> {
                try {
                    System.in.read();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            this.blockThread.start();
        }
    }

    public void stopBlock() {
        if (this.blockThread != null) {
            this.blockThread.interrupt();
            this.blockThread = null;
        }
    }

    public void regService(ServiceConfig cfg) {
        Props prop = Solon.cfg().getProp("dubbo.service." + cfg.getInterface());
        if (prop.size() > 0) {
            Utils.bindTo((Properties)prop, (Object)cfg);
        }
        cfg.export();
        this.startBlock();
    }

    public <T> T getService(Class<T> clz, Reference ref) {
        String clzKey = null;
        clzKey = ref == null ? clz.getName() : clz.getName() + "_" + ref.version();
        ReferenceConfig cfg = this.refMap.get(clzKey);
        if (cfg == null) {
            ReferenceConfig l;
            cfg = new ReferenceConfig(ref);
            cfg.setInterface(clz);
            Props prop = Solon.cfg().getProp("dubbo.reference." + cfg.getInterface());
            if (prop.size() > 0) {
                Utils.bindTo((Properties)prop, (Object)cfg);
            }
            if ((l = this.refMap.putIfAbsent(clzKey, cfg)) != null) {
                cfg = l;
            }
        }
        return (T)cfg.get();
    }
}

