/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dubbo.solon.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.noear.water.WaterClient;
import org.noear.water.dubbo.solon.plugin.RegistryUtils;
import org.noear.water.dubbo.solon.plugin.WaterRegistryLib;
import org.noear.water.model.DiscoverM;

public class WaterRegistry
implements Registry {
    private URL url;

    public WaterRegistry(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public boolean isAvailable() {
        return true;
    }

    public void destroy() {
    }

    public void register(URL url) {
        WaterRegistryLib.register(url);
    }

    public void unregister(URL url) {
        WaterRegistryLib.unregister(url);
    }

    public void subscribe(URL url, NotifyListener listener) {
        if ("consumer".equals(url.getProtocol())) {
            listener.notify(this.lookup(url));
        }
    }

    public void unsubscribe(URL url, NotifyListener listener) {
        if ("consumer".equals(url.getProtocol())) {
            listener.notify(this.lookup(url));
        }
    }

    public List<URL> lookup(URL url) {
        String service_key = RegistryUtils.buildServiceKey(url);
        String consumer = WaterClient.localService();
        String consumer_address = WaterClient.localHost();
        DiscoverM discoverM = WaterClient.Registry.discover(service_key, consumer, consumer_address);
        ArrayList<URL> list = new ArrayList<URL>();
        if (discoverM != null) {
            discoverM.list.forEach(m1 -> {
                URL tmp = RegistryUtils.buildUrl(m1);
                list.add(tmp);
            });
        }
        return list;
    }
}

