/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.dubbo.solon.plugin;

import java.util.HashSet;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.noear.solon.Solon;
import org.noear.water.WaterClient;
import org.noear.water.dubbo.solon.plugin.RegistryUtils;
import org.noear.water.utils.TaskUtils;
import org.noear.water.utils.TextUtils;

public class WaterRegistryLib {
    private static Set<URL> cached = new HashSet<URL>();
    private static boolean is_closed = false;

    public static void add(URL url) {
        cached.add(url);
    }

    public static void stop() {
        is_closed = true;
    }

    public static void start() {
        TaskUtils.run((long)4000L, () -> {
            if (is_closed) {
                return;
            }
            for (URL url : cached) {
                WaterRegistryLib.register(url);
            }
        });
    }

    public static void unregister(URL url) {
        if ("consumer".equals(url.getProtocol())) {
            return;
        }
        url = url.removeParameter("timestamp");
        String service_key = RegistryUtils.buildServiceKey(url = url.removeParameter("pid"));
        if (TextUtils.isNotEmpty((CharSequence)service_key)) {
            String meta = RegistryUtils.buildMeta(url);
            String address = url.getAuthority();
            WaterClient.Registry.unregister(service_key, address, meta);
        }
        System.out.println("unregister!!!");
    }

    public static void register(URL url) {
        if ("consumer".equals(url.getProtocol())) {
            return;
        }
        url = url.removeParameter("timestamp");
        String service_key = RegistryUtils.buildServiceKey(url = url.removeParameter("pid"));
        if (TextUtils.isNotEmpty((CharSequence)service_key)) {
            WaterRegistryLib.add(url);
            String meta = RegistryUtils.buildMeta(url);
            String address = url.getAddress();
            WaterClient.Registry.register(service_key, address, meta, Solon.cfg().isDriftMode());
        }
    }
}

